/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.networking.client;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientLoginNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.impl.networking.AbstractNetworkAddon;
import net.fabricmc.fabric.impl.networking.client.ClientNetworkingImpl;
import net.fabricmc.fabric.impl.networking.payload.PacketByteBufLoginQueryRequestPayload;
import net.fabricmc.fabric.impl.networking.payload.PacketByteBufLoginQueryResponse;
import net.fabricmc.fabric.mixin.networking.client.accessor.ClientLoginNetworkHandlerAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientHandshakePacketListenerImpl;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.login.ClientboundCustomQueryPacket;
import net.minecraft.network.protocol.login.ServerboundCustomQueryAnswerPacket;
import net.minecraft.network.protocol.login.custom.CustomQueryAnswerPayload;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public final class ClientLoginNetworkAddon
extends AbstractNetworkAddon<ClientLoginNetworking.LoginQueryRequestHandler> {
    private final ClientHandshakePacketListenerImpl handler;
    private final Minecraft client;
    private boolean firstResponse = true;

    public ClientLoginNetworkAddon(ClientHandshakePacketListenerImpl handler, Minecraft client) {
        super(ClientNetworkingImpl.LOGIN, "ClientLoginNetworkAddon for Client");
        this.handler = handler;
        this.client = client;
    }

    @Override
    protected void invokeInitEvent() {
        ((ClientLoginConnectionEvents.Init)ClientLoginConnectionEvents.INIT.invoker()).onLoginStart(this.handler, this.client);
    }

    public boolean handlePacket(ClientboundCustomQueryPacket packet) {
        PacketByteBufLoginQueryRequestPayload payload = (PacketByteBufLoginQueryRequestPayload)packet.payload();
        return this.handlePacket(packet.transactionId(), packet.payload().id(), payload.data());
    }

    private boolean handlePacket(int queryId, ResourceLocation channelName, FriendlyByteBuf originalBuf) {
        ClientLoginNetworking.LoginQueryRequestHandler handler;
        this.logger.debug("Handling inbound login response with id {} and channel with name {}", (Object)queryId, (Object)channelName);
        if (this.firstResponse) {
            ((ClientLoginConnectionEvents.QueryStart)ClientLoginConnectionEvents.QUERY_START.invoker()).onLoginQueryStart(this.handler, this.client);
            this.firstResponse = false;
        }
        if ((handler = (ClientLoginNetworking.LoginQueryRequestHandler)this.getHandler(channelName)) == null) {
            return false;
        }
        FriendlyByteBuf buf = PacketByteBufs.slice((ByteBuf)originalBuf);
        ArrayList callbacks = new ArrayList();
        try {
            CompletableFuture<@Nullable FriendlyByteBuf> future = handler.receive(this.client, this.handler, buf, callbacks::add);
            future.thenAccept(result -> {
                ServerboundCustomQueryAnswerPacket packet = new ServerboundCustomQueryAnswerPacket(queryId, (CustomQueryAnswerPayload)(result == null ? null : new PacketByteBufLoginQueryResponse((FriendlyByteBuf)result)));
                ((ClientLoginNetworkHandlerAccessor)this.handler).getConnection().send((Packet)packet, operation -> {
                    for (ChannelFutureListener callback : callbacks) {
                        callback.operationComplete(operation);
                    }
                });
            });
        }
        catch (Throwable ex) {
            this.logger.error("Encountered exception while handling in channel with name \"{}\"", (Object)channelName, (Object)ex);
            throw ex;
        }
        return true;
    }

    @Override
    protected void handleRegistration(ResourceLocation channelName) {
    }

    @Override
    protected void handleUnregistration(ResourceLocation channelName) {
    }

    @Override
    protected void invokeDisconnectEvent() {
        ((ClientLoginConnectionEvents.Disconnect)ClientLoginConnectionEvents.DISCONNECT.invoker()).onLoginDisconnect(this.handler, this.client);
    }

    @Override
    protected boolean isReservedChannel(ResourceLocation channelName) {
        return false;
    }
}

